(ns backend-adapters.s3.fetch
  (:require [backend-adapters.s3.fetch-impl :as impl]
            [shared.models.error.index :as error]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log]))

(defn convert-payload [{:keys [Body]}]
  (if (.isBuffer js/Buffer Body)
    (cv/to-clj (.parse js/JSON (.toString Body)))
    (cv/to-clj (.parse js/JSON Body))))

(defn handle-success [res]
  [:found (convert-payload res)])

(defn handle-error [error]
  (if (= (.-code error) "NoSuchKey")
    [:not-found error]
    [:failed (error/create :s3-error error)]))

(defn fetch
  ([{:keys [bucket-names] :as adapter} query]
   (impl/fetch adapter (cv/to-bucket query bucket-names) handle-error handle-success))
  ([{:keys [instance] :as adapter} credentials query]
   (.update instance.config (clj->js (assoc credentials :signatureVersion "v4")))
   (fetch adapter query)))
