(ns backend-adapters.s3.fetch-impl
  (:require [cljs.core.async :as async]
            [shared.protocols.convertible :as cv])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn- handle-response [c error-cb success-cb]
  (fn [error res]
    (go
      (if error
        (async/put! c (error-cb error))
        (async/put! c (success-cb (cv/to-clj res))))
      (async/close! c))))

(defn fetch [{:keys [instance]} query error-cb success-cb]
  (let [c (async/chan)]
    (.getObject instance (clj->js query) (handle-response c error-cb success-cb))
    c))
