(ns backend-adapters.s3.converters
  (:require [backend-shared.crypto :as crypto]))

(defn raw-user->s3 [user]
  {:key (-> user :profile :user-name)
   :body user})

(defn bookmark->s3 [{:keys [timestamp resource-url] :as bookmark}]
  {:key (str timestamp "--" (crypto/hasher resource-url))
   :body bookmark})
