(ns backend-adapters.s3.perform
  (:require [backend-adapters.s3.perform-impl :refer [save]]
            [backend-adapters.s3.converters :refer [bookmark->s3 raw-user->s3]]
            [cljs.core.async :refer [<!]]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [service action] (sp/resolve action)))

(defmethod perform [:save :raw-user] [{:keys [bucket-names] :as this} [_ payload :as action]]
  (go
    (let [[res-type :as res] (<! (save this :raw-users (raw-user->s3 payload)))]
      (if (= res-type :saved)
        (event/create [:saved payload])
        res))))

(defmethod perform [:save :bookmarks] [{:keys [bucket-names] :as this} [_ payload :as action]]
  (go
    (let [[res-type :as res] (<! (save this :bookmarks (map bookmark->s3 payload)))]
      (if (= res-type :saved)
        (event/create [:saved payload])
        res))))

(defmethod perform :invalid-action [_ action]
  (go (event/create [:failed (error/create :unsupported-action action)])))

#_(defmethod perform :default [{:keys [bucket-names] :as this} [_ payload :as action]]
  (go
    (let [queries     (cv/to-bucket (into [] payload) bucket-names)
          query-chans (async/merge (map #(put this %) queries))
          res         (async/<! (async/into [] query-chans))
          errors      (filter (fn [[result data]] (= :failed result)) res)]
      (if (empty? errors)
        (event/create [:saved (into [] payload)])
        (event/create [:failed (error/create :s3-error (map second errors))])))))
