(ns backend-adapters.s3.index
  (:require [backend-adapters.s3.converters.action :as action]
            [backend-adapters.s3.fetch :refer [fetch]]
            [backend-adapters.s3.perform :refer [perform]]
            [backend-adapters.s3.to-query :refer [to-query]]
            [backend-adapters.s3.specs]
            [cljs.nodejs :as node]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.convertible :as cv :refer [Convertible]]
            [shared.protocols.queryable :refer [Queryable]]))

(def AWS (node/require "aws-sdk"))

(defn create [{:keys [bucket-names]}]
  (specify! {:instance (new AWS.S3)
             :specs {:action :s3-adapter/action}
             :converters {:action (partial action/converter bucket-names)}}
    Queryable
    (-fetch
      ([this query] (fetch this query))
      ([this credentials query] (fetch this credentials query)))
    Actionable
    (-perform [this action] (perform this action))))

(extend-protocol Convertible
  PersistentHashMap
  (-to-bucket   [obj bucket-names] (to-query obj bucket-names))
  PersistentArrayMap
  (-to-bucket   [obj bucket-names] (to-query obj bucket-names)))

