(ns backend-adapters.s3.perform
  (:require [backend-adapters.s3.perform-impl :refer [save]]
            [cljs.core.async :refer [<!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [service action] (sp/resolve action)))

(defmethod perform :default [{:keys [converters] :as this} [_ payload :as action]]
  (go
    (let [[_ payload-type]   (sp/resolve action)
          [res-type :as res] (<! (save this payload-type payload))]
      (if (= res-type :saved)
        (event/create [:saved payload])
        res))))

(defmethod perform :invalid-action [_ action]
  (go (event/create [:failed (error/create :unsupported-action action)])))
