(ns backend-adapters.s3.perform-impl
  (:require [cljs.core.async :refer [<! chan into merge close! put!]]
            [cljs.spec.alpha :as spec]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn save-one [{:keys [converters instance]} payload-type item]
  (let [query ((:action converters) payload-type item)
        c (chan)]
    (.putObject instance (clj->js query)
                #(let [response (if %1
                                  (event/create [:failed (error/create :s3-error %1)])
                                  (event/create [:saved %2]))]
                   (put! c response)
                   (close! c)))
   c))

(defn save-many [this bucket-name payload]
  (go
    (let [query-chans (merge (map #(save-one this bucket-name %) payload))
          res         (<! (into [] query-chans))
          errors      (filter (fn [[result data]] (= :failed result)) res)]
      (if (empty? errors)
        (event/create [:saved (map second res)])
        (event/create [:failed (error/create :s3-error (map second errors))])))))

(defmulti save (fn [_ _ payload] (if (spec/valid? (spec/coll-of map?) payload) :many :one)))

(defmethod save :one [this bucket-name payload]
  (save-one this bucket-name payload))

(defmethod save :many [this bucket-name payload]
  (save-many this bucket-name payload))
