(ns backend-adapters.s3.impl.get
  (:refer-clojure :exclude [get])
  (:require [cljs.core.async :as async]
            [shared.protocols.convertible :as cv]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn convert-payload [{:keys [Body]}]
  (if (.isBuffer js/Buffer Body)
    (cv/to-clj (.parse js/JSON (.toString Body)))
    (cv/to-clj (.parse js/JSON Body))))

(defn handle-success [res]
  (event/create [:found (convert-payload res)]))

(defn handle-error [error]
  (if (= (.-code error) "NoSuchKey")
    (event/create [:not-found error])
    (event/create [:failed (error/create :s3-error error)])))

(defn- handle-response [c error res]
    (go
      (if error
        (async/put! c (handle-error error))
        (async/put! c (handle-success (cv/to-clj res))))
      (async/close! c)))

(defn get [instance query]
  (let [c (async/chan)]
    (.getObject instance (clj->js query) #(handle-response c %1 %2))
    c))
