(ns backend-adapters.s3.impl.save
  (:require [cljs.core.async :refer [<! chan into merge close! put!]]
            [cljs.spec.alpha :as spec]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn save-one [{:keys [instance]} action]
  (let [c (chan)]
    (.putObject instance (clj->js action)
                #(let [response (if %1
                                  (event/create [:failed (error/create :s3-error %1)])
                                  (event/create [:saved %2]))]
                   (put! c response)
                   (close! c)))
   c))

(defn save-many [this action]
  (go
    (let [query-chans (merge (map #(save-one this %) action))
          res         (<! (into [] query-chans))
          errors      (filter (fn [[result data]] (= :failed result)) res)]
      (if (empty? errors)
        (event/create [:saved (map second res)])
        (event/create [:failed (error/create :s3-error (map second errors))])))))

(defmulti save (fn [_ actions] (if (spec/valid? (spec/coll-of map?) actions) :many :one)))

(defmethod save :one [this action]
  (save-one this action))

(defmethod save :many [this actions]
  (save-many this actions))
