(ns backend-adapters.dynamodb.fetch
  (:refer-clojure :exclude [get])
  (:require [backend-adapters.dynamodb.converters.query :refer [query->s3]]
            [backend-adapters.dynamodb.impl.query :refer [query]]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn fetch [{:keys [instance table-names] :as adapter} q]
  (query instance (query->s3 q table-names)))
