(ns backend-adapters.dynamodb.converters.action
  (:require [shared.protocols.specced :as sp]
            [clojure.walk :as walk]))

(defn replaceEmptyStrings [obj]
  (walk/postwalk-replace {"" nil} obj))

(defmulti action->ddb (fn [action _] (sp/resolve action)))

(defmethod action->ddb [:save :course] [[_ course] table-names]
  {:TableName (:course table-names)
   :Item (-> course replaceEmptyStrings clj->js)})

(defmethod action->ddb [:save :profile] [[_ course] table-names]
  {:TableName (:profile table-names)
   :Item (-> course replaceEmptyStrings clj->js)})

(defmethod action->ddb [:save :identities] [[_ identities] table-names]
  (let [table-name (:identities table-names)
        items      (map (fn [item] {:PutRequest {:Item (-> item replaceEmptyStrings clj->js)}})
                        identities)]
    (with-meta {:RequestItems {table-name items}} {:many? true})))
