(ns backend-adapters.http.index
  (:require [shared.protocols.queryable :refer [Queryable]]
            [backend-adapters.http.fetch :refer [fetch]]
            [backend-adapters.http.specs :refer [specs]]
            [cljs.nodejs :as node]
            [shared.protocols.loggable :as log]))

(def -request (node/require "request"))
(def request (.defaults -request
                        (clj->js {:headers {:user-agent    "offcourse"}})))

(defn create [{:keys [error api-keys] :as this}]
  (specify! {:instance request
             :api-keys api-keys
             :specs specs}
    Queryable
    (-fetch [this query] (fetch this query))))
