(ns backend-adapters.http.impl.get
  (:refer-clojure :exclude [get])
  (:require [cljs.core.async :refer [chan close! put!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]
            [shared.protocols.convertible :as cv]))

(defn handle-error [error]
  (event/create [:failed (error/create :http-error error)]))

(defn handle-success [res]
  (let [statusCode (aget res "statusCode")
        body       (aget res "body")]
    (cond
      (< statusCode 400) (event/create [:found (if (string? body)
                                                 (->> body (.parse js/JSON) cv/to-clj)
                                                 (.toString body "base64"))])
      (= statusCode 404) (event/create [:not-found res])
      :default (event/create [:failed (error/create :http-error res)]))))

(defn handle-response [c error res body]
  (if error
    (put! c (handle-error error))
    (put! c (handle-success res)))
  (close! c))

(defn get [instance query]
  (let [c (chan)]
    (instance (clj->js query) #(handle-response c %1 %2 %3))
    c))
