(ns backend-adapters.http.fetch
  (:require [backend-adapters.http.converters.query :refer [query->http]]
            [backend-adapters.http.impl.get :refer [get]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti fetch (fn [_ query] (sp/resolve query)))

(defmethod fetch :default [{:keys [instance api-keys]} query]
  (get instance (query->http query api-keys)))

(defmethod fetch :invalid-query [_ query]
  (go (event/create [:failed (error/create :s3-unsupported-query query)])))
