(ns backend-shared.converters.db-event
  (:require [cljs.nodejs :as node]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log]
            [shared.models.event.index :as event]))

(def marshaler (node/require "dynamodb-marshaler"))
(def unmarshal-item (.-unmarshalItem marshaler))

(defn extract-event [{:keys [eventName dynamodb]}]
  (case eventName
    "REMOVE" (event/create [:removed (-> dynamodb :OldImage clj->js unmarshal-item cv/to-clj)])
    "MODIFY" (event/create [:saved (-> dynamodb :NewImage clj->js unmarshal-item cv/to-clj)])
    "INSERT" (event/create [:saved (-> dynamodb :NewImage clj->js unmarshal-item cv/to-clj)])))

(defn group-db-event [acc record]
  (let [[event-type event] (extract-event record)]
    (update acc event-type conj event)))

(defn ->event [{:keys [Records] :as this}]
  (event/create [:transformed (reduce group-db-event {} Records)]))
