(ns backend-shared.specs.aws.index
  (:require [cljs.spec.alpha :as spec]))

(spec/def :aws/bucket-item (spec/keys :req-un [::item-key ::bucket-name]))

(spec/def ::dynamodb map?)

(spec/def :db/record  (spec/keys :req-un [::dynamodb]))
(spec/def :db/Records (spec/coll-of :db/record))
(spec/def :aws/db-event   (spec/keys :req-un [:db/Records]))

(spec/def ::s3 map?)

(spec/def :bucket/record  (spec/keys :req-un [::s3]))
(spec/def :bucket/Records (spec/coll-of :bucket/record))
(spec/def :aws/bucket-event   (spec/keys :req-un [:bucket/Records]))


(spec/def :bucket/bucket-name string?)
(spec/def :bucket/item-key string?)
(spec/def :bucket/query (spec/keys :req-un [:bucket/item-key :bucket/bucket-name]))

(spec/def :api/body string?)

(spec/def :api/event (spec/keys :req-un [:api/body]))
