(ns backend-shared.service.fetch
  (:require [shared.protocols.queryable :as qa]
            [shared.protocols.loggable :as log]
            [cljs.core.async :as async]
            [shared.protocols.specced :as sp]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti fetch (fn [_ query] (sp/resolve query)))

(defmethod fetch :invalid-query [_ query]
  (go
    (event/create [:failed (error/create :invalid-query query)])))
