(ns backend-adapters.algolia.perform
  (:require [cljs.core.async :refer [<! put! chan]]
            [backend-adapters.algolia.converters.action :refer [action->algolia]]
            [backend-adapters.algolia.impl.save :refer [batch]]
            [shared.protocols.loggable :as log]
            [shared.models.event.index :as event]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [service action] (sp/resolve action)))

(defmethod perform [:save :courses] [{:keys [indices] :as this} [_ payload :as action]]
  (go
    (let [index (:courses indices)
          [status :as res]   (<! (batch index (action->algolia action)))]
      (if (= status :saved)
        (event/create [:saved payload])
        res))))
