(ns backend-adapters.dynamodb.index
  (:require [backend-adapters.dynamodb.fetch :refer [fetch]]
            [backend-adapters.dynamodb.perform :refer [perform]]
            [cljs.nodejs :as node]
            [shared.protocols.loggable :as log]
            [backend-adapters.dynamodb.specs :refer [specs]]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.models.event.index :as event]
            [shared.protocols.queryable :refer [Queryable]])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def AWS (node/require "aws-sdk"))

(defn create [{:keys [table-names error]}]
  (specify {:instance (AWS.DynamoDB.DocumentClient.)
            :table-names  table-names
            :error error
            :specs specs}
    Queryable
    (-fetch [table query] (fetch table query))
    Actionable
    (-perform [{:keys [error] :as this} action]
      (if error
        (go (event/create [:failed error]))
        (perform this action)))))
