(ns backend-adapters.http.converters.query
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]))

(defmulti query->http (fn [query _] (sp/resolve query)))

(defmethod query->http :portrait [{:keys [portrait-url]} _]
  {:url    portrait-url
   :encoding nil})

(defmethod query->http :repo [{:keys [owner repo-name commit-sha]} {:keys [github]}]
  {:url     (str "http://api.github.com" "/repos/" owner "/" repo-name "/git/trees/" commit-sha)
   :headers {:user-agent    "offcourse"
             :authorization (str "token " (rand-nth github))}})

(defmethod query->http :repo-item [{:keys [url]} {:keys [github]}]
  {:url      url
   :headers {:user-agent    "offcourse"
             :authorization (str "token " (rand-nth github))}})

(defmethod query->http :raw-resource [{:keys [resource-url]} {:keys [mercury]}]
  {:uri     (str "https://mercury.postlight.com" "/parser?url=" resource-url)
   :headers {:x-api-key (rand-nth mercury)}
   :encoding "utf-8"})
