(ns backend-adapters.stepfunctions.impl.execute
  (:require [cljs.core.async :refer [chan close! put!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.convertible :as cv]))

(defn- handle-response [channel error payload]
  (let [response (if error
                   (event/create [:failed (error/create :stepfunctions-error error)])
                   (event/create [:succeeded (cv/to-clj payload)]))]
    (put! channel response)
    (close! channel)))

(defn execute [instance action]
  (let [c (chan)]
    (.startExecution instance (clj->js action) #(handle-response c %1 %2))
    c))
