(ns backend-shared.converters.api
  (:require [cljs.spec.alpha :as spec]
            [shared.protocols.convertible :as cv]))

(defn res [code body]
  (-> {:statusCode code
       :headers {:Access-Control-Allow-Origin "*"}
       :body (when body (if (spec/valid? keyword? body)
                          (name body)
                          (cv/to-json body)))}
      (with-meta {:spec :offcourse/response})))

(defn ->api [[res-code message]]
  (case res-code
    :rejected  (res 401 message)
    :not-found (res 404 message)
    :failed    (res 500 message)
    (res 200 message)))
