(ns backend-shared.converters.raw-user)

(defn raw->profile [{:keys [profile auth-profile]}]
  (-> auth-profile
      (dissoc :identities :picture)
      (assoc :user-name (:user-name profile)
             :revision 1)))

(defn raw->identity [{:keys [provider user_id]} user-name]
  {:auth-id (str provider "|" user_id)
   :user-name user-name})

(defn raw->identities [{:keys [auth-profile profile]}]
  (map #(raw->identity %1 (:user-name profile)) (:identities auth-profile)))

(defn raw->portrait [{:keys [profile auth-profile]}]
  {:portrait-url (str (:picture auth-profile) "&s=300")
   :user-name (:user-name profile)})


(defn ->user-data [raw-user]
  {:profile (raw->profile raw-user)
   :portrait (raw->portrait raw-user)
   :identities (raw->identities raw-user)})
