(ns shared.models.checkpoint.index
  (:require [shared.specs.checkpoint :as specs]
            [shared.protocols.queryable :refer [Queryable]]
            [shared.protocols.loggable :as log]))

(defrecord Checkpoint [])

(defn create [{:keys [checkpoint-id] :as raw-checkpoint}]
  "creates a checkpoint"
  (let [id (str (random-uuid))]
    (-> raw-checkpoint
        map->Checkpoint
        (assoc :checkpoint-id (or checkpoint-id id))
        (with-meta {:spec :offcourse/checkpoint}))))

(defn blank [checkpoint-id]
  "creates a blank checkpoint"
  (-> {:checkpoint-id (str (random-uuid))
       :task ""
       :resource-url ""}
      map->Checkpoint
      (with-meta {:spec :offcourse/new-checkpoint})))
