(ns shared.models.status.actionable
  (:require [com.rpl.specter :refer [ALL] :refer-macros [setval transform]]
            [shared.protocols.queryable :as qa]
            [shared.paths.index :as paths]
            [shared.protocols.loggable :as log]))

(defn perform [this [_ {:keys [resource-url] :as query}]]
  (if (qa/get this query)
    (->> this
         (setval [:resources (paths/resource query)] nil)
         (transform [:resources] #(filter identity %)))
    (transform [:resources] #(conj % {:resource-url resource-url
                                      :completed? (.now js/Date)}) this)))
