(ns shared.protocols.convertible)

(defprotocol Convertible
  "The Convertible protocol allows data structures to be converted to others
  after they are checked against their specification"
  (-to-event        [this])
  (-to-db-events    [this])
  (-to-query        [this])
  (-to-status-query [this checkpoint])
  (-to-course       [this])
  (-to-checkpoint   [this])
  (-to-bookmark     [this checkpoint-id])
  (-to-bookmarks    [this])
  (-to-action       [this])
  (-to-clj          [this])
  (-to-json         [this])
  (-to-route        [this])
  (-to-url          [this routes] [this course routes]))

(defn to-bookmark
  "Converts the given data and offcourse bookmark, if the object meets the
  corresponding model specification"
  ([this] (-to-bookmark this (-> this :checkpoints first)))
  ([this checkpoint] (-to-bookmark this checkpoint)))

(defn to-bookmarks
  "Converts the given data to offcourse bookmarks, if the data meets the
  corresponding model specification"
  [this] (-to-bookmarks this))

(defn to-db-events
  "Converts an js api event to an offcourse event, if the object meets the
  corresponding model specification"
  [this] (-to-db-events this))

(defn to-event
  "Converts an js api event to an offcourse event, if the object meets the
  corresponding model specification"
  [this] (-to-event this))

(defn to-action
  "Converts an js api action to an offcourse action, if the object meets the
  corresponding model specification"
  [this] (-to-action this))

(defn to-query
  "Converts an js object to an offcourse query, if the object meets the
  corresponding model specification"
  [this] (-to-query this))

(defn to-status-query
  "Converts a course or checkpoint to a status query, if the object meets the
  corresponding model specification"
  [this checkpoint] (-to-status-query this checkpoint))

(defn to-url
  "Given a set of routes, it converts a model to a url"
  ([this routes] (-to-url this routes))
  ([this course routes] (-to-url this course routes)))

(defn to-clj
  "converts javascript data to its cljs equivalent"
  ([this] (-to-clj this)))

(defn to-json
  "converts javascript data to a json object"
  ([this] (-to-json this)))

(defn to-route
  "Given the provided viewmodel, it returns the route-params"
  ([this] (-to-route this)))

(defn to-checkpoint
  "Given the provided draft, it returns checkpoint"
  ([this] (-to-checkpoint this)))

(defn to-course
  "Given the provided draft, it returns course"
  ([this] (-to-course this)))

