(ns shared.models.status.actionable
  (:require [shared.protocols.queryable :as qa]
            [shared.protocols.loggable :as log]))

(defn perform [{:keys [resources] :as this} [_ {:keys [resource-url] :as query}]]
  (if (contains? resources resource-url)
    (update-in this [:resources] #(disj % resource-url))
    (update-in this [:resources] #(conj % resource-url))))
