(ns shared.specs.resource
  (:require [shared.specs.base :as base]
            [cljs.spec :as spec]))

(spec/def :resource/resource-url :base/url)

(spec/def :video/provider (spec/or :proper #{:youtube :vimeo}
                                   :api #{"youtube" "vimeo"}))
(spec/def :video/id string?)

(spec/def ::content        (spec/or :video (spec/keys :req-un [:video/provider
                                                               :video/id])
                                    :html (spec/nilable string?)))

(spec/def ::description    (spec/nilable string?))
(spec/def ::resource-type  (spec/or :proper #{:video :html}
                                    :api #{"video" "html"}))
(spec/def ::tags           (spec/coll-of string?))

(spec/def :resource/valid  (spec/keys :req-un [:resource/resource-url
                                               ::resource-type]
                                      :opt-un [::content
                                               ::tags
                                               ::description]))

(spec/def :resource/query     (spec/keys :req-un [::resource-url]))
