(ns shared.models.course.actionable
  (:require [com.rpl.specter :refer [ALL]]
            [shared.models.checkpoint.index :as checkpoint]
            [shared.models.course.fork :as fork]
            [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log])
  (:require-macros [com.rpl.specter.macros :refer [setval]]))

(defmulti perform (fn [course action] (sp/resolve action)))

(defmethod perform [:fork :identity] [course [_  identity]]
  (fork/fork course identity))
