(ns shared.models.status.actionable
  (:require [com.rpl.specter :refer [ALL]]
            [shared.protocols.queryable :as qa]
            [shared.paths.index :as paths]
            [shared.protocols.loggable :as log])
  (:require-macros [com.rpl.specter.macros :refer [setval transform]]))

(defn perform [this [_ {:keys [resource-url] :as query}]]
  (if (qa/get this query)
    (->> this
         (setval [:resources (paths/resource query)] nil)
         (transform [:resources] #(filter identity %)))
    (transform [:resources] #(conj % {:resource-url resource-url
                                      :completed? (.now js/Date)}) this)))
