(ns shared.models.checkpoint.index
  (:require [offcourse.specs.checkpoint :as specs]
            [shared.protocols.queryable :refer [Queryable]]
            [shared.protocols.specced :refer [Specced]]
            [shared.protocols.loggable :as log]))

(defrecord Checkpoint []
  Specced
  (-resolve [this] :checkpoint))

(defn initialize [{:keys [task resource-url]}]
  "initializes a checkpoint"
  (map->Checkpoint {:checkpoint-id (str (random-uuid))
                    :task task
                    :resource-url resource-url}))

(defn create [raw-checkpoint]
  "creates a checkpoint"
  (-> raw-checkpoint
      map->Checkpoint
      (with-meta {:spec :offcourse/checkpoint})))

(defn blank [checkpoint-id]
  "creates a blank checkpoint"
  (-> {:checkpoint-id (str (random-uuid))
       :task ""
       :resource-url ""}
      map->Checkpoint
      (with-meta {:spec :offcourse/new-checkpoint})))
