(ns shared.models.course.index
  (:require [shared.models.checkpoint.index :as checkpoint]
            [shared.models.course.convertible :as cv-impl]
            [shared.models.course.actionable :as ac-impl]
            [shared.models.course.get :as get-impl]
            [shared.models.course.missing-data :as md-impl]
            [shared.protocols.actionable :as ac :refer [Actionable]]
            [shared.protocols.convertible :refer [Convertible]]
            [shared.protocols.queryable :refer [Queryable]]
            [shared.protocols.specced :refer [Specced]]
            [shared.protocols.loggable :as log]
            [clojure.set :as set]))

(defrecord Course []
  Queryable
  (-get [this query] (get-impl/get this query))
  (-missing-data [this query] (md-impl/missing-data this query))
  Actionable
  (-perform [this action] (ac-impl/perform this action))
  Convertible
  (-to-bookmarks [this] (cv-impl/to-bookmarks this))
  (-to-query [this] (cv-impl/to-query this))
  (-to-status-query [this checkpoint] (cv-impl/to-status-query this checkpoint))
  Specced
  (-resolve [this] :courses))

(defn initialize [{:keys [goal curator checkpoints]}]
  (let [course-id (str (random-uuid))]
    {:base-id course-id
     :course-id course-id
     :repository "offcourse"
     :revision 0
     :parent-id nil
     :curator curator
     :goal goal
     :parent nil
     :timestamp (.now js/Date)
     :checkpoints (map checkpoint/initialize checkpoints)}))

(defn create [course]
  (-> course
      (update :checkpoints #(map checkpoint/create %1))
      map->Course
      (with-meta {:spec :offcourse/course})))
