(ns shared.models.payload.index
  (:require [shared.models.payload.to-model :refer [to-model]]
            [cljs.spec.alpha :as spec]
            [shared.models.payload.to-query :refer [to-query]]
            [shared.protocols.convertible :refer [Convertible]]
            [shared.protocols.specced :refer [Specced]]
            [shared.protocols.loggable :as log]))

(defn- override [payload]
  (specify payload
    Convertible
    (-to-query [this] (to-query this))
    (-to-model [this] (to-model this))
    Specced
    (-resolve [this]
      (let [resolved-payload (spec/conform (:spec (meta this)) this)]
        (if (= (clj->js resolved-payload) "invalid")
          :invalid-payload
          (first resolved-payload))))))

(defn create
  "creates a new payload"
  [raw-payload]
  (-> (if (map? raw-payload) raw-payload (into [] raw-payload))
      (with-meta {:spec :offcourse/payload})
      override))
