(ns offcourse.specs.helpers
  (:require [cljs.spec.alpha :as spec]))

(defn tuple-spec [valid-types payload]
  (spec/tuple (into #{} valid-types) payload))

(defn one-or-many? [item]
  (first (spec/conform (spec/or :one map?
                                :many (spec/* map?)) item)))

(defn one? [item]
  (= (one-or-many? item) :one))

(defn min-length [str min] (>= (count str) min))
(defn max-length [str max] (<= (count str) max))

(defn many? [item]
  (= (one-or-many? item) :many))
