(ns ui-components.forms.new-user
  (:require [ui-components.semantic :refer [Button Message Header Segment Form FormField FormInput]]
            [ui-components.forms.sections.controls :refer [FormControls]]
            [ui-components.forms.utils :refer [debounce submit-form]]
            [shared.protocols.specced :as sp]
            [reagent.core :as r]
            [shared.protocols.loggable :as log]))


(defn update-user-name [local-state new-name]
  (swap! local-state assoc :user-name new-name))

(defn NewUserForm [{:keys [user on-submit on-change on-cancel]}]
  (let [local-state (r/atom user)
        update-user-name (comp (debounce on-change 1000) update-user-name)]
    (fn [{:keys [status]}]
      (let [{:keys [user-name] :as user} @local-state
            valid? (sp/valid? user)
            saveable? (and valid? (= status :checked))
            errors (sp/errors user)
            invalid-fields (into #{} (mapcat :in (-> errors first second)))]
        [Segment {:basic true}
         [Header "Sign Up"]
          [Form {:error (= status :rejected)
                 :onSubmit #(submit-form %1 user on-submit)}
           [Message {:error true} "This username already exists..."]
          [FormField
           [:label "User Name"]
           [FormInput {:placeholder "please enter your name..."
                       :autoFocus true
                       :value (or user-name "")
                       :error (contains? invalid-fields :user-name)
                       :onChange #(update-user-name local-state (.-value %2))}]]
          [FormControls {:on-cancel on-cancel
                         :loading?  (= status :checking)
                         :disabled? (not saveable?)}]]]))))
