(ns ui-components.layouts.checkpoint
  (:require [ui-components.semantic :refer [Segment Button Grid GridColumn GridRow]]
            [ui-components.course-card :refer [CourseCard]]
            [ui-components.dashboard :refer [Dashboard]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [ui-components.viewer :refer [Viewer]]
            [shared.protocols.loggable :as log]))

(defn ControlPanel [{:keys [authenticable? editable? navigatable? forkable?]} handlers]
  (cond
    editable?      [Button {:onClick (:edit-course handlers) :fluid   true} "Edit"]
    navigatable?   [Button {:onClick (:go-to-fork handlers) :fluid   true} "Edit"]
    forkable?      [Button {:onClick (:fork-course handlers) :fluid   true} "Edit"]
    authenticable? [Button {:onClick (:sign-in handlers) :fluid   true} "Edit"]
    :default       [Button {:disabled true :fluid true} "Edit"]))


(defn CheckpointLayout [{:keys [affordances user course resource checkpoint respond handlers] :as view-data}]
  (let [button-handlers     {:edit-course (partial (:edit-course handlers) course)
                             :go-to-fork  #((:switch-to handlers) :redirect-modal)
                             :fork-course #((:switch-to handlers) :fork-modal)
                             :sign-in (:sign-in handlers)}
        toggle-status       (case (:status user)
                              :signed-in  (partial (:toggle-status handlers) course)
                              :signed-out (:sign-in handlers)
                              identity)]
    [BaseLayout
     view-data
     [Grid {:padded true}
      [GridRow {:only :mobile}
       [GridColumn
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]

      [GridRow {:only :tablet}
       [GridColumn
        [Dashboard
         [CourseCard {:course        course
                      :trackable?    true
                      :toggle-status toggle-status}]
         [ControlPanel affordances button-handlers]]
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]

      [GridRow {:only :computer}
       [GridColumn
        [Dashboard
         [CourseCard {:course        course
                      :trackable?    true
                      :toggle-status toggle-status}]
         [Segment {:basic true}
          [ControlPanel affordances button-handlers]]]
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]]]))
