(ns ui-components.layouts.new-course
  (:require [ui-components.forms.new-course :refer [NewCourseForm]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [shared.protocols.loggable :as log]
            [ui-components.semantic :refer [Modal]]))

(defn NewCourseLayout [{:keys [affordances busy? draft respond handlers] :as view-data}]
  (let [{:keys [editable? saveable?]} affordances]
    [BaseLayout
     view-data
     (when editable? [NewCourseForm {:course      draft
                                     :affordances affordances
                                     :busy?       busy?
                                     :on-cancel   (:go-home handlers)
                                     :on-change   (:check-course handlers)
                                     :on-submit   (:save-course handlers)}])]))
