(ns ui-components.actions-panel
  (:require [cuerdas.core :as str]
            [ui-components.semantic
             :refer
             [Button Icon Item JSItem Loader MenuMenu]]
            [reagent.core :as r]
            [shared.protocols.loggable :as log]))


(defn LoggedInMenu [user-name sign-out]
  [MenuMenu {:position :right}
   [Item
    [Button {:basic true}
     [:a {:href "/courses/new"} "Create Course"]]]
   [Item
    [Button {:basic true} (str/capitalize user-name)]]
   [Item
    [Button {:basic true
             :on-click sign-out} "Sign Out"]]])

(defn LoadingMenu [local-state]
  [MenuMenu {:position :right}
   [Item [Loader {:active true
                  :size :mini
                  :inline true}]]])

(defn GuestMenu [sign-in]
  [MenuMenu {:position :right}
   [Item
    [Button {:basic true
             :on-click sign-in} "Sign In"]]])

(def local-state (r/atom {:is-signing-in? false}))

(defn ActionsPanel [{:keys [user-status flags user-name sign-in sign-out]}]
  (let [{:keys [signed-in? signed-out?]} flags]
    (cond
      signed-in?  [LoggedInMenu user-name sign-out]
      signed-out? [GuestMenu sign-in]
      :default LoadingMenu)))
