(ns ui-components.layouts.checkpoint
  (:require [ui-components.semantic :refer [Segment Grid GridColumn GridRow]]
            [ui-components.course-card :refer [CourseCard]]
            [ui-components.control-panel :refer [ControlPanel]]
            [ui-components.dashboard :refer [Dashboard]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [ui-components.viewer :refer [Viewer]]
            [shared.protocols.loggable :as log]))

(defn CheckpointLayout [{:keys [flags user course resource checkpoint respond handlers] :as view-data}]
  (let [button-handlers     {:edit-course (partial (:edit-course handlers) course)
                             :go-to-fork  #((:switch-to handlers) :redirect-modal)
                             :fork-course #((:switch-to handlers) :fork-modal)
                             :sign-in (:sign-in handlers)}
        {:keys [signed-in? signed-out?]} flags
        toggle-status       (cond
                              signed-in?  (partial (:toggle-status handlers) course)
                              signed-out? (:sign-in handlers)
                              :default     identity)]
    [BaseLayout
     view-data
     [Grid {:padded true}
      [GridRow {:only :mobile}
       [GridColumn
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]

      [GridRow {:only :tablet}
       [GridColumn
        [Dashboard
         [CourseCard {:course        course
                      :trackable?    true
                      :toggle-status toggle-status}]
         [ControlPanel {:flags flags
                        :handlers button-handlers}]]
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]

      [GridRow {:only :computer}
       [GridColumn
        [Dashboard
         [CourseCard {:course        course
                      :trackable?    true
                      :toggle-status toggle-status}]
         [Segment {:basic true}
          [ControlPanel {:flags flags
                         :handlers button-handlers}]]]
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]]]))
