(ns ui-components.layouts.new-course
  (:require [ui-components.forms.new-course :refer [NewCourseForm]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [shared.protocols.loggable :as log]
            [ui-components.semantic :refer [Modal]]))

(defn NewCourseLayout [{:keys [flags invalid-fields draft respond handlers] :as view-data}]
  [BaseLayout
   view-data
   (when (:signed-in? flags)
     [NewCourseForm {:draft       draft
                     :flags       flags
                     :on-cancel   (:go-home handlers)
                     :on-change   (:check-course handlers)
                     :on-submit   (:save-draft handlers)}])])
