(ns ui-components.forms.sections.controls
  (:require [ui-components.forms.utils :refer [prevent-default]]
            [ui-components.semantic :refer [Button]]))

(defn FormControls [{:keys [on-cancel on-confirm loading? disabled? confirm-message cancel-message]}]
  [:div
   [Button {:color :red
            :onClick #(prevent-default % on-cancel)} (or cancel-message "Cancel")]
   [Button {:primary true
            :loading loading?
            :disabled disabled?
            :onClick #(prevent-default % on-confirm)} (or confirm-message "Save")]])
