(ns ui-components.forms.new-course
  (:require [shared.protocols.actionable :as ac]
            [ui-components.button :refer [Button]]
            [ui-components.forms.sections.checkpoints :refer [CheckpointsSection]]
            [ui-components.forms.sections.controls :refer [FormControls]]
            [ui-components.forms.sections.goal :refer [GoalSection]]
            [ui-components.forms.utils :refer [prevent-default]]
            [ui-components.overlay :refer [Overlay]]
            [ui-components.semantic :refer [Form]]
            [shared.protocols.loggable :as log]))

(defn NewCourseForm [{:keys [draft flags handlers]}]
  [Overlay {:title "Create Course"}
   [Form {:error (boolean (:errors draft))
          :onSubmit #(prevent-default %1 identity)}
    [GoalSection {:goal   (:goal draft)
                  :errors (-> draft :errors :goal)
                  :update (:update-goal handlers)}]
    [CheckpointsSection {:update-checkpoint (:update-checkpoint handlers)
                         :remove-checkpoint (:remove-checkpoint handlers)
                         :errors            (-> draft :errors :checkpoints)
                         :checkpoints       (:checkpoints draft)}]]
   [FormControls {:on-cancel  (:on-cancel handlers)
                  :on-confirm (:on-submit handlers)
                  :loading?   (:checking? flags)
                  :disabled?  (not (:saveable? flags))}
    [Button {:on-click (:create-checkpoint handlers)} "Add Checkpoint"]]])
