(ns ui-components.forms.sections.checkpoint
  (:require [ui-components.semantic :refer [Button Icon FormField FormGroup FormInput]]
            [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]))

(defn CheckpointSection [{:keys [on-change on-remove]} {:keys [task errors resource-url valid?] :as checkpoint}]
  [FormGroup
   [FormField {:width 6
               :error (boolean (:task errors))}
    [:label "Task"]
    [FormInput {:placeholder "Task"
                :value (or task "")
                :onChange #(on-change (assoc checkpoint :task (.-value %2)))}]]
   [FormField {:width 9
               :error (boolean (:resource-url errors))}
    [:label "Resource Url"]
    [FormInput {:placeholder "Url"
                :value (or resource-url "")
                :error (boolean (:resource-url errors))
                :onChange #(on-change (assoc checkpoint :resource-url (.-value %2)))}]]
   [FormField {:width 1}
    [:label {:className "invisible"} "."]
    [Button {:fluid true
             :icon "remove"
             :onClick #(on-remove checkpoint)}]]])
