(ns ui-components.layouts.new-course
  (:require [ui-components.forms.course :refer [CourseForm]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [shared.protocols.loggable :as log]
            [ui-components.semantic :refer [Modal]]))

(defn NewCourseLayout [{:keys [flags invalid-fields course-draft respond handlers] :as view-data}]
  [BaseLayout
   view-data
   (when (:signed-in? flags)
     [CourseForm {:draft       course-draft
                  :flags       flags
                  :errors      (:errors course-draft)
                  :handlers    {:on-cancel         (:go-home handlers)
                                :update-goal       (:update-goal handlers)
                                :update-checkpoint (:update-checkpoint handlers)
                                :remove-checkpoint (:remove-checkpoint handlers)
                                :create-checkpoint (:create-checkpoint handlers)
                                :on-submit         (:save-draft handlers)}}])])
