(ns ui-components.forms.confirmation
  (:require [ui-components.semantic :refer [Button Message Header Segment Form FormField FormInput]]
            [ui-components.forms.sections.confirmation-code :refer [ConfirmationCodeSection]]
            [ui-components.forms.sections.controls :refer [FormControls]]
            [ui-components.forms.utils :refer [prevent-default]]
            [ui-components.overlay :refer [Overlay]]
            [shared.protocols.specced :as sp]
            [reagent.core :as r]
            [shared.protocols.loggable :as log]))

(defn update-confirmation-code [profile-atom confirmation-code]
  (swap! profile-atom (fn [profile] (assoc profile :confirmation-code confirmation-code))))

(defn ConfirmationForm [{:keys [draft on-submit on-change on-cancel]}]
  (let [profile (r/atom draft)]
    (fn [{:keys [flags errors]}]
      [Overlay {:title "Confirm"}
       [Form {:error (boolean errors)
              :onSubmit #(prevent-default %1 identity)}
        [ConfirmationCodeSection {:confirmation-code (:confirmation-code @profile)
                                  :errors (-> errors :confirmation-code)
                                  :update #(-> (update-confirmation-code profile %))}]]
       [FormControls {:on-cancel on-cancel
                      :on-confirm #(on-submit @profile)
                      :loading?  (:checking? flags)
                      :disabled? false}]])))
