(ns ui-components.course-meta
  (:require [ui-components.semantic
             :refer
             [ItemGroup Item ItemDescription ItemContent Image ItemHeader Image ItemMeta]]
            [cuerdas.core :as str]))

(defn CourseMeta [{:keys [curator] :as course}]
  [ItemGroup
   [Item
   [Image {:as :div
           :size :mini
           :src (:portrait-url (meta course))}]
   [ItemContent {:verticalAlign :top}
    [ItemMeta "Curated by"]
    [ItemHeader [:a {:href (str "/curators/" curator)}(str/capitalize curator)]]
    #_[ItemDescription "Learners 345 Stats 123 Stats 123"]]]])
