/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.Date;

public class EchoHandler
implements Handler {
    private static final String timeFormat = "hh:mm:ss";

    @Override
    public Response generateResponse(Request request) {
        String method = request.getMethod();
        String messageBody = "";
        switch (method) {
            case "HEAD": {
                return this.buildHeadResponse();
            }
            case "GET": {
                return this.buildGetResponse();
            }
        }
        return new Response.Builder(405).build();
    }

    private Response buildHeadResponse() {
        String messageBody = this.createMessageBody();
        int contentLength = MessageHeader.determineContentLength(messageBody);
        return new Response.Builder(200).setHeader("Content-Type", "text/plain").setHeader("Content-Length", contentLength).build();
    }

    private Response buildGetResponse() {
        String messageBody = this.createMessageBody();
        int contentLength = MessageHeader.determineContentLength(messageBody);
        return new Response.Builder(200).setHeader("Content-Type", "text/plain").setHeader("Content-Length", contentLength).messageBody(messageBody).build();
    }

    private String createMessageBody() {
        return "Hello, world: " + this.getFormattedTime();
    }

    private String getFormattedTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(timeFormat);
        return dateFormat.format(new Date());
    }
}

