/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonPatchParser {
    public ArrayList<JsonPatchOperation> getOperations(String body) throws BadRequestException {
        try {
            ArrayList<JsonPatchOperation> operations = new ArrayList<JsonPatchOperation>();
            for (JSONObject jsonPatchObject : new JSONArray(body)) {
                JsonPatchOperation operation = this.createPatchFromJsonObject(jsonPatchObject);
                operations.add(operation);
            }
            return operations;
        }
        catch (Exception e) {
            System.out.println(e);
            throw new BadRequestException("Could not parse application/json-patch+json");
        }
    }

    private JsonPatchOperation createPatchFromJsonObject(JSONObject jsonObject) throws BadRequestException {
        try {
            switch (jsonObject.getString("op")) {
                case "add": {
                    return this.createJsonPatchAdd(jsonObject);
                }
                case "remove": {
                    return this.createJsonPatchRemove(jsonObject);
                }
                case "replace": {
                    return this.createJsonPatchReplace(jsonObject);
                }
                case "move": {
                    return this.createJsonPatchMove(jsonObject);
                }
                case "copy": {
                    return this.createJsonPatchCopy(jsonObject);
                }
            }
            throw new BadRequestException(jsonObject.getString("op") + " is not a valid JSON PATCH operation.");
        }
        catch (JSONException e) {
            System.out.println((Object)e);
            throw new BadRequestException("Couldn't parse JSON Patch operation");
        }
    }

    private JsonPatchOperation createJsonPatchAdd(JSONObject jsonObject) {
        String op = jsonObject.getString("op");
        String path = jsonObject.getString("path");
        String value = jsonObject.getString("value");
        return new JsonPatchAdd(op, path, value);
    }

    private JsonPatchOperation createJsonPatchRemove(JSONObject jsonObject) {
        String op = jsonObject.getString("op");
        String path = jsonObject.getString("path");
        return new JsonPatchRemove(op, path);
    }

    private JsonPatchOperation createJsonPatchReplace(JSONObject jsonObject) {
        String op = jsonObject.getString("op");
        String path = jsonObject.getString("path");
        String value = jsonObject.getString("value");
        return new JsonPatchReplace(op, path, value);
    }

    private JsonPatchOperation createJsonPatchMove(JSONObject jsonObject) {
        String op = jsonObject.getString("op");
        String from = jsonObject.getString("from");
        String path = jsonObject.getString("path");
        return new JsonPatchMove(op, from, path);
    }

    private JsonPatchOperation createJsonPatchCopy(JSONObject jsonObject) {
        String op = jsonObject.getString("op");
        String from = jsonObject.getString("from");
        String path = jsonObject.getString("path");
        return new JsonPatchCopy(op, from, path);
    }
}

