// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.seq');
goog.require('cljs.core');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('clojure.set');
/**
 * Concat then turn into vector
 */
chimera.seq.concatv = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,cljs.core.concat);
chimera.seq.filter_first = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.filter);
chimera.seq.not_empty_QMARK_ = cljs.core.complement(cljs.core.empty_QMARK_);
chimera.seq.select_values = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.vals,cljs.core.select_keys);
chimera.seq.select_value = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.first,chimera.seq.select_values);
/**
 * Return a list of all items that appear more than once in a sequence.
 */
chimera.seq.duplicates = (function chimera$seq$duplicates(l){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__51144_SHARP_){
if((cljs.core.last(p1__51144_SHARP_) > (1))){
return cljs.core.first(p1__51144_SHARP_);
} else {
return null;
}
}),cljs.core.frequencies(l));
});
/**
 * True is map has all these keys.
 */
chimera.seq.has_keys_QMARK_ = (function chimera$seq$has_keys_QMARK_(m,keys){
return cljs.core.every_QMARK_(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.contains_QMARK_,m),keys);
});
/**
 * True if elem is in list, false otherwise.
 */
chimera.seq.in_QMARK_ = (function chimera$seq$in_QMARK_(list,elem){
return cljs.core.boolean$(cljs.core.some((function (p1__51145_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(elem,p1__51145_SHARP_);
}),list));
});
chimera.seq.mapply = (function chimera$seq$mapply(var_args){
var args__7658__auto__ = [];
var len__7651__auto___51148 = arguments.length;
var i__7652__auto___51149 = (0);
while(true){
if((i__7652__auto___51149 < len__7651__auto___51148)){
args__7658__auto__.push((arguments[i__7652__auto___51149]));

var G__51150 = (i__7652__auto___51149 + (1));
i__7652__auto___51149 = G__51150;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.concat,cljs.core.butlast(args),cljs.core.last(args)));
});

chimera.seq.mapply.cljs$lang$maxFixedArity = (1);

chimera.seq.mapply.cljs$lang$applyTo = (function (seq51146){
var G__51147 = cljs.core.first(seq51146);
var seq51146__$1 = cljs.core.next(seq51146);
return chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(G__51147,seq51146__$1);
});

chimera.seq.sort_by_category = (function chimera$seq$sort_by_category(sort_by_key,collection){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (item){
var G__51152 = cljs.core.cst$kw$metadata.cljs$core$IFn$_invoke$arity$1(item);
return (sort_by_key.cljs$core$IFn$_invoke$arity$1 ? sort_by_key.cljs$core$IFn$_invoke$arity$1(G__51152) : sort_by_key.call(null,G__51152));
}),collection);
});
/**
 * Apply a function to each value of a map. From http://goo.gl/JdwzZf
 */
chimera.seq.update_values = (function chimera$seq$update_values(var_args){
var args__7658__auto__ = [];
var len__7651__auto___51160 = arguments.length;
var i__7652__auto___51161 = (0);
while(true){
if((i__7652__auto___51161 < len__7651__auto___51160)){
args__7658__auto__.push((arguments[i__7652__auto___51161]));

var G__51162 = (i__7652__auto___51161 + (1));
i__7652__auto___51161 = G__51162;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return chimera.seq.update_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

chimera.seq.update_values.cljs$core$IFn$_invoke$arity$variadic = (function (m,f,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p__51156){
var vec__51157 = p__51156;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51157,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51157,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(r,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,v,args));
}),cljs.core.PersistentArrayMap.EMPTY,m);
});

chimera.seq.update_values.cljs$lang$maxFixedArity = (2);

chimera.seq.update_values.cljs$lang$applyTo = (function (seq51153){
var G__51154 = cljs.core.first(seq51153);
var seq51153__$1 = cljs.core.next(seq51153);
var G__51155 = cljs.core.first(seq51153__$1);
var seq51153__$2 = cljs.core.next(seq51153__$1);
return chimera.seq.update_values.cljs$core$IFn$_invoke$arity$variadic(G__51154,G__51155,seq51153__$2);
});

chimera.seq.sort_by_name = (function chimera$seq$sort_by_name(sort_by_key,collection){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__51163_SHARP_){
return clojure.string.lower_case((sort_by_key.cljs$core$IFn$_invoke$arity$1 ? sort_by_key.cljs$core$IFn$_invoke$arity$1(p1__51163_SHARP_) : sort_by_key.call(null,p1__51163_SHARP_)));
}),collection);
});
/**
 * Removes elem from a vector by its position.
 */
chimera.seq.dissoc_vec = (function chimera$seq$dissoc_vec(coll,pos){
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(coll,(0),pos),cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(coll,(pos + (1)))));
});
/**
 * Like core/assoc-in but accepting multiple key vectors and values
 * (assoc-in* coll & args)
 */
chimera.seq.assoc_in_multi = (function chimera$seq$assoc_in_multi(var_args){
var args__7658__auto__ = [];
var len__7651__auto___51174 = arguments.length;
var i__7652__auto___51175 = (0);
while(true){
if((i__7652__auto___51175 < len__7651__auto___51174)){
args__7658__auto__.push((arguments[i__7652__auto___51175]));

var G__51176 = (i__7652__auto___51175 + (1));
i__7652__auto___51175 = G__51176;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.seq.assoc_in_multi.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.seq.assoc_in_multi.cljs$core$IFn$_invoke$arity$variadic = (function (coll,args){
if(cljs.core.even_QMARK_){
} else {
throw (new Error("Assert failed: even?"));
}

if(cljs.core.truth_(cljs.core.count(args))){
} else {
throw (new Error("Assert failed: (count args)"));
}

var pairs = cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),args);
var reducer = ((function (pairs){
return (function (skeleton_map,p__51170){
var vec__51171 = p__51170;
var keys = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51171,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51171,(1),null);
return cljs.core.assoc_in(skeleton_map,keys,value);
});})(pairs))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(reducer,coll,pairs);
});

chimera.seq.assoc_in_multi.cljs$lang$maxFixedArity = (1);

chimera.seq.assoc_in_multi.cljs$lang$applyTo = (function (seq51168){
var G__51169 = cljs.core.first(seq51168);
var seq51168__$1 = cljs.core.next(seq51168);
return chimera.seq.assoc_in_multi.cljs$core$IFn$_invoke$arity$variadic(G__51169,seq51168__$1);
});

/**
 * Deep merge any number of maps.
 */
chimera.seq.deep_merge = (function chimera$seq$deep_merge(var_args){
var args__7658__auto__ = [];
var len__7651__auto___51178 = arguments.length;
var i__7652__auto___51179 = (0);
while(true){
if((i__7652__auto___51179 < len__7651__auto___51178)){
args__7658__auto__.push((arguments[i__7652__auto___51179]));

var G__51180 = (i__7652__auto___51179 + (1));
i__7652__auto___51179 = G__51180;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return chimera.seq.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

chimera.seq.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,(function (x,y){
if(cljs.core.map_QMARK_(y)){
return chimera.seq.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([x,y], 0));
} else {
if(cljs.core.vector_QMARK_(y)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y);
} else {
return y;

}
}
}),maps);
});

chimera.seq.deep_merge.cljs$lang$maxFixedArity = (0);

chimera.seq.deep_merge.cljs$lang$applyTo = (function (seq51177){
return chimera.seq.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq51177));
});

/**
 * Apply func to pred matching k value to v.
 */
chimera.seq.fn_collection = (function chimera$seq$fn_collection(func,k,v,collection){
if(cljs.core.truth_(v)){
var G__51184 = (function (p1__51181_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,(k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(p1__51181_SHARP_) : k.call(null,p1__51181_SHARP_)));
});
var G__51185 = collection;
return (func.cljs$core$IFn$_invoke$arity$2 ? func.cljs$core$IFn$_invoke$arity$2(G__51184,G__51185) : func.call(null,G__51184,G__51185));
} else {
return collection;
}
});
/**
 * Keeps values in list maps where k value matchs v
 */
chimera.seq.filter_collection = (function chimera$seq$filter_collection(k,v,collection){
return chimera.seq.fn_collection(cljs.core.filter,k,v,collection);
});
/**
 * Removes values in list maps where k value matchs cond
 */
chimera.seq.filter_out_collection = (function chimera$seq$filter_out_collection(k,v,collection){
return chimera.seq.fn_collection(cljs.core.remove,k,v,collection);
});
/**
 * Remove map entries where the value is falsey.
 */
chimera.seq.remove_falsey_values = (function chimera$seq$remove_falsey_values(a_map){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,cljs.core.second),a_map));
});
/**
 * Return collections with a key matching the query.
 */
chimera.seq.search_collection = (function chimera$seq$search_collection(var_args){
var args51186 = [];
var len__7651__auto___51195 = arguments.length;
var i__7652__auto___51196 = (0);
while(true){
if((i__7652__auto___51196 < len__7651__auto___51195)){
args51186.push((arguments[i__7652__auto___51196]));

var G__51197 = (i__7652__auto___51196 + (1));
i__7652__auto___51196 = G__51197;
continue;
} else {
}
break;
}

var G__51188 = args51186.length;
switch (G__51188) {
case 3:
return chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args51186.length)].join('')));

}
});

chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$3 = (function (query,collection,k){
return chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$4(query,collection,k,true);
});

chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$4 = (function (query,collection,k,case_insensitive_QMARK_){
var query_cased = (cljs.core.truth_(case_insensitive_QMARK_)?clojure.string.lower_case(query):query);
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,(function (){var iter__7326__auto__ = ((function (query_cased){
return (function chimera$seq$iter__51189(s__51190){
return (new cljs.core.LazySeq(null,((function (query_cased){
return (function (){
var s__51190__$1 = s__51190;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__51190__$1);
if(temp__4657__auto__){
var s__51190__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51190__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__51190__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__51192 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__51191 = (0);
while(true){
if((i__51191 < size__7325__auto__)){
var member = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__51191);
var v = (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(member) : k.call(null,member));
var v_cased = (cljs.core.truth_(case_insensitive_QMARK_)?clojure.string.lower_case(v):v);
if(cljs.core.truth_(chimera.string.substring_QMARK_(query_cased,v_cased))){
cljs.core.chunk_append(b__51192,member);

var G__51199 = (i__51191 + (1));
i__51191 = G__51199;
continue;
} else {
var G__51200 = (i__51191 + (1));
i__51191 = G__51200;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51192),chimera$seq$iter__51189(cljs.core.chunk_rest(s__51190__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51192),null);
}
} else {
var member = cljs.core.first(s__51190__$2);
var v = (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(member) : k.call(null,member));
var v_cased = (cljs.core.truth_(case_insensitive_QMARK_)?clojure.string.lower_case(v):v);
if(cljs.core.truth_(chimera.string.substring_QMARK_(query_cased,v_cased))){
return cljs.core.cons(member,chimera$seq$iter__51189(cljs.core.rest(s__51190__$2)));
} else {
var G__51201 = cljs.core.rest(s__51190__$2);
s__51190__$1 = G__51201;
continue;
}
}
} else {
return null;
}
break;
}
});})(query_cased))
,null,null));
});})(query_cased))
;
return iter__7326__auto__(collection);
})());
});

chimera.seq.search_collection.cljs$lang$maxFixedArity = 4;

/**
 * Returns the position of at which pred is true for items in coll.
 */
chimera.seq.positions = (function chimera$seq$positions(pred,coll){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,x){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(x) : pred.call(null,x)))){
return idx;
} else {
return null;
}
}),coll);
});
/**
 * Returns index of an item within a collection.
 */
chimera.seq.index_of = (function chimera$seq$index_of(coll,item){
return cljs.core.first(chimera.seq.positions(cljs.core.PersistentHashSet.fromArray([item], true),coll));
});
/**
 * Update map value in list based on key match
 */
chimera.seq.update_map_in_list = (function chimera$seq$update_map_in_list(list,map_to_update,key_to_match){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__51202_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((key_to_match.cljs$core$IFn$_invoke$arity$1 ? key_to_match.cljs$core$IFn$_invoke$arity$1(p1__51202_SHARP_) : key_to_match.call(null,p1__51202_SHARP_)),(key_to_match.cljs$core$IFn$_invoke$arity$1 ? key_to_match.cljs$core$IFn$_invoke$arity$1(map_to_update) : key_to_match.call(null,map_to_update)))){
return map_to_update;
} else {
return p1__51202_SHARP_;
}
}),list);
});
/**
 * Basically lifted from http://stackoverflow.com/a/17902228/420386
 */
chimera.seq.flatten_map = (function chimera$seq$flatten_map(var_args){
var args51203 = [];
var len__7651__auto___51210 = arguments.length;
var i__7652__auto___51211 = (0);
while(true){
if((i__7652__auto___51211 < len__7651__auto___51210)){
args51203.push((arguments[i__7652__auto___51211]));

var G__51212 = (i__7652__auto___51211 + (1));
i__7652__auto___51211 = G__51212;
continue;
} else {
}
break;
}

var G__51205 = args51203.length;
switch (G__51205) {
case 1:
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args51203.length)].join('')));

}
});

chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$1 = (function (form){
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$2(form,"/");
});

chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$2 = (function (form,separator){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$3(form,separator,null));
});

chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$3 = (function (form,separator,prefix){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__51206){
var vec__51207 = p__51206;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51207,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51207,(1),null);
var full_prefix = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str(separator),cljs.core.str(cljs.core.name(key))].join(''):cljs.core.name(key));
if(cljs.core.map_QMARK_(value)){
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$3(value,separator,full_prefix);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [full_prefix,value], null)], null);
}
}),cljs.core.array_seq([form], 0));
});

chimera.seq.flatten_map.cljs$lang$maxFixedArity = 3;

/**
 * Return difference between 2 sequences.
 */
chimera.seq.diff = (function chimera$seq$diff(a,b){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set(a),cljs.core.set(b));
});
/**
 * Return difference between 2 sequences. Preserves ordering in first seq.
 */
chimera.seq.ordered_diff = (function chimera$seq$ordered_diff(a,b){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__51214_SHARP_){
return !(cljs.core.contains_QMARK_(cljs.core.set(b),p1__51214_SHARP_));
}),a);
});
/**
 * Merges two sequeneces
 */
chimera.seq.union = (function chimera$seq$union(a,b){
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.set(a),cljs.core.set(b));
});
/**
 * Remove nil values from a sequence.
 */
chimera.seq.remove_nil = (function chimera$seq$remove_nil(l){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,l);
});
/**
 * Removes x from coll if present, and adds if absent.
 */
chimera.seq.toggle = (function chimera$seq$toggle(coll,x){
if(cljs.core.contains_QMARK_(cljs.core.set(coll),x)){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__51215_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,p1__51215_SHARP_);
}),coll);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
chimera.seq.indexed = (function chimera$seq$indexed(coll){
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,coll);
});
chimera.seq.transpose = (function chimera$seq$transpose(m){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.mapv,cljs.core.vector,m);
});
/**
 * Get the first map from a list of maps with the given value for key.
 */
chimera.seq.map_list__GT_map = (function chimera$seq$map_list__GT_map(map_list,k,v){
var G__51219 = (function (p1__51216_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(p1__51216_SHARP_) : k.call(null,p1__51216_SHARP_)),v);
});
var G__51220 = map_list;
return (chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2 ? chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2(G__51219,G__51220) : chimera.seq.filter_first.call(null,G__51219,G__51220));
});
/**
 * Recursively transforms all map keys from keywords to strings.
 */
chimera.seq.full_stringify_keys = (function chimera$seq$full_stringify_keys(m){
var f = (function (p__51225){
var vec__51226 = p__51225;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51226,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51226,(1),null);
if((k instanceof cljs.core.Keyword)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$2([cljs.core.str(k)].join(''),(1)),v], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null);
}
});
return clojure.walk.postwalk(((function (f){
return (function (x){
if(cljs.core.map_QMARK_(x)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,x));
} else {
return x;
}
});})(f))
,m);
});
/**
 * Adds an element to a vector
 */
chimera.seq.add_element = (function chimera$seq$add_element(vector,element){
return cljs.core.vec(cljs.core.set(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vector,(element | (0)))));
});
/**
 * Removes an element to a vector
 */
chimera.seq.remove_element = (function chimera$seq$remove_element(vector,element){
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (e){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(e,element);
}),vector));
});
