// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('chimera.core');
goog.require('clojure.string');
goog.require('cljs.pprint');
chimera.string.email_regex = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i;
chimera.string.twitter_username_regex = /^[A-Za-z0-9_]*$/;
chimera.string.domain_name_regex = /([a-z0-9|-]+\.)*[a-z0-9|-]+\.[a-z]+/;
chimera.string.truncate_if_longer_than = (50);
chimera.string.ellipsis_start = (36);
chimera.string.ellipsis_stop_from_end = (12);
/**
 * Return true if string value is true else false
 */
chimera.string.str_is_true_QMARK_ = (function chimera$string$str_is_true_QMARK_(value){
var and__6531__auto__ = value;
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(value),"true");
} else {
return and__6531__auto__;
}
});
chimera.string.chars__GT_entities = new cljs.core.PersistentArrayMap(null, 5, ["<","&lt;",">","&gt;","&","&amp;","\"","&quot;","'","&#39;"], null);
chimera.string.vowel_QMARK_ = cljs.core.set("aeiou");
chimera.string.parenthesize_suffix = (function chimera$string$parenthesize_suffix(prefix,suffix){
return [cljs.core.str(prefix),cljs.core.str(" ("),cljs.core.str(suffix),cljs.core.str(")")].join('');
});
/**
 * Shorten a string to a certain length with middle ellipsis.
 */
chimera.string.truncate_with_ellipsis = (function chimera$string$truncate_with_ellipsis(s){
if((cljs.core.count(s) > chimera.string.truncate_if_longer_than)){
var end_start = (cljs.core.count(s) - chimera.string.ellipsis_stop_from_end);
return [cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),chimera.string.ellipsis_start)),cljs.core.str("..."),cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,end_start))].join('');
} else {
return s;
}
});
/**
 * Return the first character of a string capitalized.
 */
chimera.string.first_cap = (function chimera$string$first_cap(s){
return clojure.string.capitalize([cljs.core.str(cljs.core.first(s))].join(''));
});
/**
 * True if `s` is an email address.
 */
chimera.string.is_email_QMARK_ = (function chimera$string$is_email_QMARK_(s){
return cljs.core.first(s.match(chimera.string.email_regex));
});
/**
 * True if `s` is a valid twitter username
 */
chimera.string.is_twitter_username_QMARK_ = (function chimera$string$is_twitter_username_QMARK_(s){
return cljs.core.first(s.match(chimera.string.twitter_username_regex));
});
/**
 * Wrap the count of a collection in parens and postfix.
 */
chimera.string.postfix_paren_count = (function chimera$string$postfix_paren_count(prefix,collection){
return chimera.string.parenthesize_suffix(prefix,cljs.core.count(collection));
});
/**
 * True if `s` ends with the passed suffix.
 */
chimera.string.ends_with_QMARK_ = (function chimera$string$ends_with_QMARK_(s,suffix){
var offset = (cljs.core.count(s) - cljs.core.count(suffix));
return ((offset >= (0))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(suffix,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,offset)));
});
/**
 * Serialize a Clojure map to JavaScript string map.
 */
chimera.string.map__GT_js_string_map = (function chimera$string$map__GT_js_string_map(m){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["{",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",(function (){var iter__7326__auto__ = (function chimera$string$map__GT_js_string_map_$_iter__51132(s__51133){
return (new cljs.core.LazySeq(null,(function (){
var s__51133__$1 = s__51133;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__51133__$1);
if(temp__4657__auto__){
var s__51133__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51133__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__51133__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__51135 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__51134 = (0);
while(true){
if((i__51134 < size__7325__auto__)){
var vec__51144 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__51134);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51144,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51144,(1),null);
cljs.core.chunk_append(b__51135,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null));

var G__51150 = (i__51134 + (1));
i__51134 = G__51150;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51135),chimera$string$map__GT_js_string_map_$_iter__51132(cljs.core.chunk_rest(s__51133__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51135),null);
}
} else {
var vec__51147 = cljs.core.first(s__51133__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51147,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51147,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null),chimera$string$map__GT_js_string_map_$_iter__51132(cljs.core.rest(s__51133__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(m);
})()),"}"], null)));
});
/**
 * True if the first letter of `s` is a vowel.
 */
chimera.string.begins_with_vowel_QMARK_ = (function chimera$string$begins_with_vowel_QMARK_(s){
var G__51152 = cljs.core.first(clojure.string.lower_case(cljs.core.first(s)));
return (chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1(G__51152) : chimera.string.vowel_QMARK_.call(null,G__51152));
});
/**
 * If `s` is a string and equal to 'false' in lower case return false,
 * otherwise return `s`.
 */
chimera.string.false_str__GT_false = (function chimera$string$false_str__GT_false(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var and__6531__auto__ = typeof s === 'string';
if(and__6531__auto__){
return clojure.string.lower_case(s);
} else {
return and__6531__auto__;
}
})(),"false")){
return false;
} else {
return s;
}
});
/**
 * Render a JSON error as a string for the user.
 */
chimera.string.error_json__GT_str = (function chimera$string$error_json__GT_str(json){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("<br/>",(function (){var iter__7326__auto__ = (function chimera$string$error_json__GT_str_$_iter__51175(s__51176){
return (new cljs.core.LazySeq(null,(function (){
var s__51176__$1 = s__51176;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__51176__$1);
if(temp__4657__auto__){
var s__51176__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51176__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__51176__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__51178 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__51177 = (0);
while(true){
if((i__51177 < size__7325__auto__)){
var vec__51189 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__51177);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51189,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51189,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__51192 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__51192);
} else {
return G__51192;
}
})();
cljs.core.chunk_append(b__51178,[cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''));

var G__51197 = (i__51177 + (1));
i__51177 = G__51197;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51178),chimera$string$error_json__GT_str_$_iter__51175(cljs.core.chunk_rest(s__51176__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51178),null);
}
} else {
var vec__51193 = cljs.core.first(s__51176__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51193,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51193,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__51196 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__51196);
} else {
return G__51196;
}
})();
return cljs.core.cons([cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''),chimera$string$error_json__GT_str_$_iter__51175(cljs.core.rest(s__51176__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(json);
})());
});
/**
 * Build an unescaped string.
 */
chimera.string.unescape = (function chimera$string$unescape(s){
if(typeof s === 'string'){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p__51202){
var vec__51203 = p__51202;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51203,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51203,(1),null);
return clojure.string.replace(r,cljs.core.re_pattern(v),[cljs.core.str(k)].join(''));
}),s,chimera.string.chars__GT_entities);
} else {
return s;
}
});
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",s);
});
/**
 * Checks if a variable is null or nil
 */
chimera.string.is_null_or_nil_QMARK_ = (function chimera$string$is_null_or_nil_QMARK_(s){
var or__6543__auto__ = chimera.string.is_null_QMARK_(s);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (s == null);
}
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement(chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case(str);
} else {
return null;
}
});
/**
 * True if substring is a substring of `s`
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___51213 = arguments.length;
var i__7652__auto___51214 = (0);
while(true){
if((i__7652__auto___51214 < len__7651__auto___51213)){
args__7658__auto__.push((arguments[i__7652__auto___51214]));

var G__51215 = (i__7652__auto___51214 + (1));
i__7652__auto___51214 = G__51215;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,s,p__51209){
var map__51210 = p__51209;
var map__51210__$1 = ((((!((map__51210 == null)))?((((map__51210.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51210.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51210):map__51210);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__51210__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_,true);
if(cljs.core.truth_((function (){var or__6543__auto__ = cljs.core.empty_QMARK_(s);
if(or__6543__auto__){
return or__6543__auto__;
} else {
return chimera.string.is_null_QMARK_(s);
}
})())){
return false;
} else {
var G__51212 = cljs.core.re_find(cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)")),cljs.core.str(substring)].join('')),s);
return (chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(G__51212) : chimera.core.not_nil_QMARK_.call(null,G__51212));
}
});

chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2);

chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq51206){
var G__51207 = cljs.core.first(seq51206);
var seq51206__$1 = cljs.core.next(seq51206);
var G__51208 = cljs.core.first(seq51206__$1);
var seq51206__$2 = cljs.core.next(seq51206__$1);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__51207,G__51208,seq51206__$2);
});

/**
 * Insert a comma into numbers in thousands and higher
 */
chimera.string.humanize_number = (function chimera$string$humanize_number(n){
return cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.array_seq([n], 0));
});
/**
 * Escape for types. Replaces characters in the string with this base on
 *   chars->entities map.
 */
chimera.string.escape_for_type = (function chimera$string$escape_for_type(x){
if((x == null)){
return "null";
} else {
if(typeof x === 'string'){
return clojure.string.escape(x,chimera.string.chars__GT_entities);
} else {
return x;

}
}
});
chimera.string.get_query_params_str = (function chimera$string$get_query_params_str(var_args){
var args__7658__auto__ = [];
var len__7651__auto___51223 = arguments.length;
var i__7652__auto___51224 = (0);
while(true){
if((i__7652__auto___51224 < len__7651__auto___51223)){
args__7658__auto__.push((arguments[i__7652__auto___51224]));

var G__51225 = (i__7652__auto___51224 + (1));
i__7652__auto___51224 = G__51225;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic = (function (query_params_map,p__51218){
var vec__51219 = p__51218;
var query_param_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51219,(0),null);

var query_param_str__$1 = [cljs.core.str(query_param_str)].join('');
var query_param_str_blank_QMARK_ = clojure.string.blank_QMARK_(query_param_str__$1);
var key = cljs.core.first(cljs.core.keys(query_params_map));
var query_param_key = cljs.core.name((function (){var or__6543__auto__ = key;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "";
}
})());
var query_param_val = (function (){var and__6531__auto__ = key;
if(cljs.core.truth_(and__6531__auto__)){
return (key.cljs$core$IFn$_invoke$arity$1 ? key.cljs$core$IFn$_invoke$arity$1(query_params_map) : key.call(null,query_params_map));
} else {
return and__6531__auto__;
}
})();
var G__51222 = cljs.core.count(query_params_map);
switch (G__51222) {
case (0):
return null;

break;
case (1):
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?",query_param_key,"=",query_param_val], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_param_str__$1,"&",query_param_key,"=",query_param_val], null)));

break;
default:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.string.get_query_params_str,((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_params_map,[cljs.core.str("?")].join('')], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.rest(query_params_map)),[cljs.core.str(query_param_str__$1),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query_param_str__$1,"?"))?null:"&")),cljs.core.str(query_param_key),cljs.core.str("="),cljs.core.str(query_param_val)].join('')], null)));

}
});

chimera.string.get_query_params_str.cljs$lang$maxFixedArity = (1);

chimera.string.get_query_params_str.cljs$lang$applyTo = (function (seq51216){
var G__51217 = cljs.core.first(seq51216);
var seq51216__$1 = cljs.core.next(seq51216);
return chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic(G__51217,seq51216__$1);
});

